/*
 * Copyright (c) 1999-2001 Lutris Technologies, Inc. All Rights
 * Reserved.
 * 
 * This source code file is distributed by Lutris Technologies, Inc. for
 * use only by licensed users of product(s) that include this source
 * file. Use of this source file or the software that uses it is covered
 * by the terms and conditions of the Lutris Enhydra Development License
 * Agreement included with this product.
 * 
 * This Software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF
 * ANY KIND, either express or implied. See the License for the specific terms
 * governing rights and limitations under the License.
 * 
 * Contributor(s):
 * 
 * $Id: Attribute.java,v 1.1.1.1 2001/01/05 05:11:17 sese0235 Exp $
 */

package de.kxml;

/**
 * Attribute class, used by both kDom and the pullparser.  The
 * instances of this class are immutable. This restriction allows
 * manipulation aware element implementations without needing to care
 * about hidden changes in attributes.
 */
public class Attribute {
    String namespace;
    String name;
    String value;

    /**
     * Creates a new Attribute instance with the given name and
     * value. The namespace is set to "".
     */
    public Attribute(String name, String value) {
	this.namespace = "";
	this.name = name;
	this.value = value;
    }

    /**
     * creates a new Attribute with the given namespace, name and
     * value
     */
    public Attribute(String namespace, String name, String value) {
	this.namespace = namespace == null ? "" : namespace;
	this.name = name;
	this.value = value;
    }

    /**
     * returns the string value of the attribute
     */
    public String getValue() {
	return value;
    } 

    /**
     * returns the name of the attribute
     */
    public String getName() {
	return name;
    } 

    /**
     * returns the namespace of the attribute
     */
    public String getNamespace() {
	return namespace;
    } 

    /**
     * Method declaration
     *
     *
     * @return
     *
     * @see
     */
    public String toString() {
	return (!namespace.equals("") ? ("{" + namespace + "}" + name) : name) 
	       + "=\"" + value + "\"";
    } 

}

